﻿using System;
using System.Configuration; 
using System.Web;
using System.Web.Configuration; 
using System.Web.Caching;
using System.Collections; 
using System.Collections.Generic;
using System.Linq;
using System.Linq.Dynamic;
using System.Text;
using System.Data;
using System.Data.Linq;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessAHOBPR;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.Validation;

namespace VeteransAffairs.Registries.BusinessManagerAHOBPR
{
    [Serializable()]
    public abstract class AHOBPRBaseBO 
    {

        #region public events

        /// <summary>
        /// Event to raise when an encounter is selected.  The EventArgs for the event will contain the selected encounter id.
        /// </summary>
        [field: NonSerialized]
        public event BOSaveSuccessEvent BOSaveSuccess;

        public delegate void BOSaveSuccessEvent(object sender, BOSaveSuccessEventArgs e);

        public class BOSaveSuccessEventArgs : EventArgs
        {
            public int SavedItemId { get; set; }
            public SaveStatus SaveStatusArg { get; set; }
            public string SaveErrorMessage { get; set; }
        }

        protected void RaiseSaveEvent(object sender, BOSaveSuccessEventArgs args)
        {
            //raise event
            if (this.BOSaveSuccess != null)
            {
                this.BOSaveSuccess(sender, args);
            }
        }

        public enum SaveStatus
        {
            SaveSuccess = 1,
            SaveFail = 0
        }

        #endregion
        
        protected string _defaultSortField;
        protected static AHOBPRDataAccess _dbAhobpr;
        protected static RegistriesDataAccess _dbRegistry;
        //protected DataLoadOptions lo = new DataLoadOptions();

        protected static AHOBPRDataAccess GetDataContext()
        {
            AHOBPRDataAccess db = new AHOBPRDataAccess(BusinessAHOBPR.GlobalSettings.DALConnectionString);
            db.CommandTimeout = GetConfigEntryOrDefault("CommandTimeout", 3600);
                  
            return db;
        }

        protected static RegistriesDataAccess GetRegistryDataContext()
        {
            RegistriesDataAccess db = new RegistriesDataAccess(Business.GlobalSettings.DALConnectionString);
            db.CommandTimeout = GetConfigEntryOrDefault("CommandTimeout", 3600);

            return db;
        }


        private static int GetConfigEntryOrDefault(string key, int defaultVal)
        {
            string value = WebConfigurationManager.AppSettings.Get(key);

            if (string.IsNullOrEmpty(value))
                return defaultVal;

            int result;
            if (int.TryParse(value, out result))
                return result;

            else
                throw new ConfigurationException("Specified key is invalid");
        }

        protected static Cache Cache
        {
            get { return HttpContext.Current.Cache; }  

        }

        protected static string ConvertNullToEmptyString(string dataString)
        {
            return (dataString == null ? "" : dataString);

        }

        protected static void PurgeCacheItems(string prefix)
        {
            List<string> itemsToRemove = new List<string>();
            
            IDictionaryEnumerator enumerator = Cache.GetEnumerator();

            while (enumerator.MoveNext())
            {
                if (enumerator.Key.ToString().StartsWith(prefix))
                {
                    itemsToRemove.Add(enumerator.Key.ToString()); 

                }
            }

            itemsToRemove.ForEach(c => Cache.Remove(c));   
        }

        private bool CheckValid(bool throwException)
        {
            try
            {
                // Just delegate this and catch/handle any business rule exceptions.
                CheckValid();
            }
            catch (VABusinessRuleViolationException)
            {
                if (throwException)
                {
                    throw;
                }
                return false;
            }

            return true;
        }

        /// <summary>
        /// Business objects implement custom validation logic here, throwing exceptions if any rules aren't satisfied.
        /// </summary>
        protected virtual void CheckValid()
        {
        }

        /// <summary>
        /// Expose whether or not this object is currently in a state valid for update.
        /// </summary>
        public bool IsValid
        {
            get { return CheckValid(false); }
        }

        private ValidationErrorsCollection _valErrors;
        public ValidationErrorsCollection ValidationErrors { get{return _valErrors;}  set { _valErrors = value; } }

        public string UserName
        {
            get{
                return ((UserAccountManager)System.Threading.Thread.CurrentPrincipal).Identity.Name;
            }
        }

        public UserAccountManager UserMgr
        {
            get
            {
                return ((UserAccountManager)System.Threading.Thread.CurrentPrincipal);
            }
        }

     }
}
